//
// (c) 2021 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.12

import wesual.Create 1.0
import wesual.Ui     1.0

MouseArea {
    id : delegate

    property bool supportsContextMenu : true
    property alias asset : thumbnail.asset

    signal requestSelect(var asset)

    implicitHeight : 83
    implicitWidth : 83

    onDoubleClicked : requestSelect(asset)

    AssetThumbnail {
        id : thumbnail

        anchors.fill : parent
        asset : modelData
    }

    UiBorder {
        anchors.fill : parent
        borderWidth : 1
        color : UiColors.getColor(UiColors.Black, .1)
        style : UiBorder.Solid
    }

    UiTooltip {
        text : asset.label
    }

    UiContextMenu {
        enabled : delegate.supportsContextMenu

        UiMenuItem {
            text : qsTrId("72fd25eaf2a053da")
            iconName : "visible"

            onTriggered : delegate.requestSelect(asset)
        }
    }
}
